
/** config **/
var _AUTO_ROTATOR = true; // Czy wlaczyc autorotator.
var _AUTO_ROTATOR_LOOP_TIME = 5000; // Czas co ile ma sie automatycznie zmieniac rotator.
var _ROTATOR_ANIMATE_TIME = 500; // Czas przejscia miedzy slajdami.

/**
* Kolekcja obiektow + singleton.
*/
var core = {
    _o: [],
    _r: false,
    // Dodaje obiekt do utworzenia po DOM Ready.
    run: function(name,object) {
        if(core._r) {
            var inst = new object;
            core._o.push({
                name: name,
                object: object,
                instance: inst
            });
            inst.init();
            return;
        }
        core._o.push({
            name: name,
            object: object,
            instance: null
        });
    },
    // Wywolywane przez jQuery dla DOMReady.
    init: function() {
        if(core._r) return;
        core._r = true;
        var inst;
        for(var i in core._o) {
            inst = new core._o[i].object;
            core._o[i].instance = inst;
            inst.init();
        }
    },
    // Zwraca instancje obiektu po nazwie.
    // Uzycie np.: core.instance('search');
    instance: function(name) {
        for(var i in core._o)
            if(core._o[i].name === name)
                return core._o[i].instance;
        return null;
    }
}

if($) $(document).ready(core.init);

/**
* BigSplash na HomePage.
*/
core.run('bigsplash',function()
{
    this.splashIv = false;
    this.lock = false;
    this.current = 0;
    this.count = 0;
    this.$ul = null;
    this.$ctrl = null;
    this.init = function()
    {
        var $bs = $('#bigSplash');
        if(!$bs.get(0)) return;
        var $splash = $bs.find('> div.splash');
        this.$ul = $splash.find('> ul');
        this.$li = this.$ul.find('> li');
        this.$li.css({
            position:"absolute",
            left:9999,top:0
        });
        this.$li.eq(0).css({left:0}).addClass('select');

        // Budujemy liste pozycji w panelu sterujacym Splashem.
        var t = '<div class="control">';
        var c = 0;
        t += '<a href="" class="prev">&lsaquo;</a>';
        this.$li.each(function(a,b) {
            t += '<a href=""';
            if(c == 0) t += ' class="select"';
            t += '>' +(++c)+ '</a>';
        });
        t += '<a href="" class="next">&rsaquo;</a>';
        t += '</div>';
        $splash.append(t);

        // Podpinamy OnClick.
        var t = this;
        this.$ctrl = $splash.find('> div.control > a');
        this.$ctrl.click(function() {
            if(t.lock) return false;
            $t = $(this);
            if($t.hasClass('next')) {
                t.userSelected(t,(++t.current)%t.count);
            } else if($t.hasClass('prev')) {
                if((--t.current) < 0) t.current = t.count-1;
                t.userSelected(t,t.current);
            } else {
                t.current = parseInt($t.html(),10)-1;
                t.userSelected(t,t.current);
            }
            return false;
        });

        this.count = c;
        // Odpalamy automatyczny rotator.
        if(_AUTO_ROTATOR) {
            this.splashIv = window.setInterval(function() {
                t.rotate(t);
            },_AUTO_ROTATOR_LOOP_TIME);
        }
    };
    this.userSelected = function(instance,no) {
        // Klikniecie wylacza automatyczna rotacje.
        if(instance.splashIv) {
            window.clearInterval(instance.splashIv);
            instance.splashIv = null;
        }
        instance.change(no);
    };
    this.change = function(no) {
        no = no + 1;
        if(no > this.count || no <= 0) return;
        if(this.lock) return;
        this.lock = true;
        var t = this;
        no--;
        this.$ctrl.eq(0).parent().find('.select').removeClass('select');
        this.$ctrl.eq(no+1).addClass('select');

        var $old = this.$ul.find('.select');

        if($old.get(0)) {
            $old.css('zIndex',10).removeClass('select');
        }

        this.$li.eq(no).hide().css({
            zIndex:20,
            left:0
        }).addClass('select').fadeIn(_ROTATOR_ANIMATE_TIME,function() {
            if($old.get(0))
                $old.css('left',9999);
            t.lock = false;
        });
    };
    this.rotate = function(instance) {

        ++instance.current;

        instance.current = (instance.current)%instance.count;

        instance.current+1;

        instance.change(instance.current);
    };
});

/**
* Szukajka.
*/
core.run('search',function()
{
    this.welcome = 'Wyszukaj na stronie...';
    this.init = function() {
        var $i = $('#search input[type=text]');
        if(!$i.get(0)) return;
        if($i.val() == '')
            $i.val(this.welcome);
        var t = this;
        $i.focus(function() {
            if($i.val() == t.welcome)
                $i.val('');
        });
        $i.blur(function() {
            if($i.val() == '')
                $i.val(t.welcome);
        });
    };
});

/**
* Zmiana kolejnosci blokow na stronie glownej.
*/
core.run('newsboxorder',function()
{
    this.$objects = false;
    this.init = function() {
        this.mount(false);
    };
    // Montuje eventy na przyciskach w gore/w dol.
    this.mount = function(update) {
        var $objects = $('#content > .newsBox');
        var inst = this;
        this.$objects = [];
        $objects.each(function() {
            var $t = $(this);
            // //
            // Pomijanie specyficznych obiektow.
            if($t.hasClass('promoAsus') || $t.hasClass('noMove'))
                return true;
            //
            // //
            inst.$objects.push(this);
            $t.find('> div.header > span.control > a')
                .unbind('click').click(function() {return inst.click(inst,this);});
        });
        if(update) this.update();
    };
    // Klikniecie w zmiane pozycji.
    this.click = function(instance,a) {
        var $a = $(a);
        var $box = $a.parent().parent().parent();
        var _box = $box.get(0);
        var way = $a.hasClass('down') ? 1 : -1;

        // Szukamy na ktorym miejscu jest nasz boks.
        var oldIndex = -1;
        var count = 0;
        for(var i in instance.$objects) {
            if(_box === instance.$objects[i]) {
                oldIndex = count;
                break;
            }
            count++;
        }
        if(oldIndex < 0 || // Nie znaleziono.
            (oldIndex === 0 && way === -1) || // Pierwszy element do gory.
            (oldIndex === instance.$objects.length-1 && way === 1)) // Ostatni element na dol.
            return false;

        // Przenosimy dzieki klonowaniu obiektow.
        var $item0 = $(instance.$objects[oldIndex + way]);
        $box.before($item0.clone());
        $item0.after($box.clone());
        $box.remove();
        $item0.remove();

        instance.mount(true);
        return false;
    };
    // Aktualizujemy aplikacje o zmianach.
    this.update = function()
    {
        // Budujemy liste z kolejnoscia.
        var data = [];
        for(var i in this.$objects) {
            data.push($(this.$objects[i]).attr('id'));
        }

        $.ajax({
            url: '/index.php/boxes/update',
            data: {order: data},
            dataType: 'json',
            type: 'post'
        });
    }
});

