
var obj = null;

if (window.XMLHttpRequest) {
	obj = new XMLHttpRequest();
} else if (window.ActiveXObject) {
	obj = new ActiveXObject("Microsoft.XMLHTTP");
}

function getXMLHttpRequestObject()
{
	try{
		return new XMLHttpRequest();
	}
	catch(e){
		try{
		  return new ActiveXObject("Microsoft.XMLHTTP");
		}
		catch(e){
			return false;
		}
	}
}

function startPOSTRequest(url, params, onComplete, onEnd) {
	var XMLHttpRequestObject = getXMLHttpRequestObject();
	if(XMLHttpRequestObject){
		XMLHttpRequestObject.open("POST", url);
		XMLHttpRequestObject.setRequestHeader(
			'Content-Type', 'application/x-www-form-urlencoded');
		XMLHttpRequestObject.onreadystatechange = function()
		{
			if (XMLHttpRequestObject.readyState == 4){
				if(XMLHttpRequestObject.status == 200){
					var responseXML = XMLHttpRequestObject.responseXML;
					var responseText = XMLHttpRequestObject.responseText;
					onComplete(responseText, responseXML);
				}
				delete XMLHttpRequestObject;
				onEnd();
			}
		}
		XMLHttpRequestObject.send(params);
	}
}

//setLoadStatus
function sLS(ls){
	document.getElementById('tL').innerHTML = ls;
}

function removePost(id){
	var answer = confirm("Czy napewno chcesz usunąć wybrany post?");
	var target = document.getElementById("post"+id);
	if (answer) {
		if (obj) {
			obj.open("GET", "/actions/removePost.php?postId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.style.display = "none";
					//alert("Post został usunięty");
					//location.reload();
				}
			}
			obj.send(null);
		}
	}
}


function removeThread(id){
	var answer = confirm("Czy napewno chcesz usunąć wybrany temat?");
	if (answer) {
		if (obj) {
			obj.open("GET", "/actions/removeThread.php?threadId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					alert("Temat został usunięty");
					location.reload();
				}
			}
			obj.send(null);
		}
	}
}

function postAnswer(id){
	var answer = document.getElementById("fAnswer").value;
	if (answer == "") {
		alert('Nie możesz wysłać pustej odpowiedzi');
	} else {
		var url = "/actions/postAnswer.php";
		var params = "threadId=" + id + "&content=" + encodeURIComponent(answer);
		onComplete = function() {
			location.reload();
		}
		onEnd = function() {}
		startPOSTRequest(url, params, onComplete, onEnd);
	}
}

function markAsSolution(id){
	if (id) {
		if (obj) {
			obj.open("GET", "/actions/markAsSolution.php?postId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					alert("Odpowiedź została oznaczona jako rozwiązanie problemu.");
					location.reload();
				}
			}
			obj.send(null);
		}
	}

}

function updatePost(id){
	var content = document.getElementById("updateContent"+id).value;
	var url = "/actions/updatePost.php";
	var params = "postId=" + id + "&content=" + encodeURIComponent(content);
	onComplete = function() {
		alert("Treść postu została zaktualizowana.");
		Hide("postEditArea"+id);
		location.reload();
	}
	onEnd = function() {}
	startPOSTRequest(url, params, onComplete, onEnd);
}

function updateThread(id){
	var title = document.getElementById("updateThreadTitle").value;
	var catId = document.getElementById("updateThreadCategory").value;
	var content = document.getElementById("updateThreadContent").value;
	var tags = document.getElementById("updateThreadTags").value;
	var url = "/actions/updateThread.php";
	var params =
		"threadId=" + id +
		"&content=" + encodeURIComponent(content) +
		"&title=" + encodeURIComponent(title) +
		"&tags=" + encodeURIComponent(tags) +
		"&catId=" + catId;
	onComplete = function() {
		alert("Treść tematu została zaktualizowana.");
		location.href = '/forum,'+id+',-.html';
	}
	onEnd = function() {}
	startPOSTRequest(url, params, onComplete, onEnd);
}

function postThread(id){
	var content = document.getElementById("newThreadContent").value;
	var topic = document.getElementById("newThreadTopic").value;
	var tags = document.getElementById("newThreadTags").value;
	if (id) {
		if (obj) {
			obj.open("GET", "/actions/postThread.php?catId=" + id + "&content=" + encodeURIComponent(content) + "&title=" + encodeURIComponent(topic) + "&tags=" + encodeURIComponent(tags));
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					alert('Nowy wątek został rozpoczęty');
					location.reload();
				}
			}
			obj.send(null);
		}
	}
}

var currentPageId = 1;

function viewPage(id){
	var pages = getElementsByClassName("page");

	var i = 0;
	var page = document.getElementById("page"+id);
	var currentPage = document.getElementById("page"+currentPageId);


	for (i = 0; i<pages.length; i++) {
		pages[i].style.display = 'none';
	}

	if (currentPage) {
		currentPage.style.display = 'block';
	}

	var i = 0;
	var delay = 0;

	// ukrywanie aktualnej strony (currentPageId):
	for (i = 0; i <= 1; i += 0.01) {
		delay += i*6;
		step = 1 - i;
		setTimeout('setPageOpacity('+currentPageId+', '+step+')', delay);
	}
	setTimeout('Hide("page'+currentPageId+'")', delay);

	// odkrywanie strony docelowej (id)
	setTimeout('Show("page'+id+'")', delay);

	for (i = 0; i <= 1; i += 0.01) {
		step = i;
		setTimeout('setPageOpacity('+id+', '+step+')', delay);
		delay += i*4;
	}

	currentPageId = id;
}

function setPageOpacity(id, opacity){

	var page = document.getElementById("page"+id);
	page.style.opacity = opacity;
	page.style.filter = 'alpha(opacity='+ opacity*100 +')';

}


function showAllPages(){
	var pages = getElementsByClassName("page");
	var i;

	for (i = 0; i<pages.length; i++) {
		pages[i].style.display = 'block';
		setPageOpacity(i+1, 1);
	}
}

function closeThread(id){
	var answer = confirm("System dokona automatycznego podsumowania tematu. Czy napewno chcesz zamknąć wybrany temat?");
	if (answer) {
		if (obj) {
			obj.open("GET", "/actions/closeThread.php?threadId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					alert(obj.responseText);
					location.reload();
				}
			}
			obj.send(null);
		}
	}
}

function openThread(id){
	var answer = confirm("Możesz ponownie otworzyć ten wątek jako moderator. Czy chcesz to zrobić?");
	if (answer) {
		if (obj) {
			obj.open("GET", "/actions/openThread.php?threadId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					alert(obj.responseText);
					location.reload();
				}
			}
			obj.send(null);
		}
	}
}

var threadPrevStatus = new Array();


function getThreadPreview(id){

	obj.abort();

	var target = document.getElementById("previewAreaInner"+id);
	Show("previewArea"+id);

	if (threadPrevStatus[id] != true) {
		if (obj) {
			obj.open("GET", "/actions/getThreadPreview.php?threadId=" + id);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.innerHTML = obj.responseText;
					threadPrevStatus[id] = true;
				}
			}
			obj.send(null);
		}
	} else {
		//alert(1);
	}
}

function ratePost(postId, rate){
	var target = document.getElementById("postRate"+postId);
	if (postId && rate) {
		if (obj) {
			obj.open("GET", "/actions/ratePost.php?postId=" + postId + "&rate=" + rate);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.innerHTML = obj.responseText;
				}
			}
			obj.send(null);
		}
	}
}


function insertTag(tag, element){
	var tArea = document.getElementById(element);
	var isIE = (document.all)? true : false;
	var open = '[' + tag + ']';
	var end = '[/' + tag + ']';

	if(isIE){
		tArea.focus();
		var curSelect = document.selection.createRange();
		if(arguments[2]){
			curSelect.text = open + arguments[2] + "]" + curSelect.text + end;
		} else {
			curSelect.text = open + curSelect.text + end;
		}
	} else if(!isIE && typeof tArea.selectionStart != "undefined"){

		var selStart = tArea.value.substr(0, tArea.selectionStart);
		var selEnd = tArea.value.substr(tArea.selectionEnd, tArea.value.length);
		var curSelection = tArea.value.replace(selStart, '').replace(selEnd, '');
		if(arguments[2]){
			tArea.value = selStart + open + arguments[2] + "]" + curSelection + end + selEnd;
		} else {
			tArea.value = selStart + open + curSelection + end + selEnd;
		}
	} else {
		tArea.value += (arguments[2])? open + arguments[2] + "]" + end : open + end;
	}
}

function insert_text(text, spaces, targetId) {

	var textarea = document.getElementById(targetId);

	if (spaces)
	{
		text = ' ' + text + ' ';
	}

	if (!isNaN(textarea.selectionStart))
	{
		var sel_start = textarea.selectionStart;
		var sel_end = textarea.selectionEnd;

		mozWrap(textarea, text, '')
		textarea.selectionStart = sel_start + text.length;
		textarea.selectionEnd = sel_end + text.length;
	}

	else if (textarea.createTextRange && textarea.caretPos)
	{
		if (baseHeight != textarea.caretPos.boundingHeight)
		{
			textarea.focus();
			storeCaret(textarea);
		}
		var caret_pos = textarea.caretPos;
		caret_pos.text = caret_pos.text.charAt(caret_pos.text.length - 1) == ' ' ? caret_pos.text + text + ' ' : caret_pos.text + text;

	}
	else
	{
		textarea.value = textarea.value + text;
	}
	textarea.focus();
}

/**
* From http://www.massless.org/mozedit/
*/
function mozWrap(txtarea, open, close)
{
	var selLength = txtarea.textLength;
	var selStart = txtarea.selectionStart;
	var selEnd = txtarea.selectionEnd;
	var scrollTop = txtarea.scrollTop;

	if (selEnd == 1 || selEnd == 2)
	{
		selEnd = selLength;
	}

	var s1 = (txtarea.value).substring(0,selStart);
	var s2 = (txtarea.value).substring(selStart, selEnd)
	var s3 = (txtarea.value).substring(selEnd, selLength);

	txtarea.value = s1 + open + s2 + close + s3;
	txtarea.selectionStart = selEnd + open.length + close.length;
	txtarea.selectionEnd = txtarea.selectionStart;
	txtarea.focus();
	txtarea.scrollTop = scrollTop;

	return;
}

function insertURL(element) {
	var tArea = document.getElementById(element);
	var isIE = (document.all)? true : false;

	var url = prompt('Podaj adres: ');
	var name = prompt('Nazwa wyświetlana: ');

	var open = '[url=' + url + ']';
	var end = name + '[/url]';

	if(isIE){
		tArea.focus();
		var curSelect = document.selection.createRange();
		if(arguments[2]){
			curSelect.text = open + arguments[2] + "]" + curSelect.text + end;
		} else {
			curSelect.text = open + curSelect.text + end;
		}
	} else if(!isIE && typeof tArea.selectionStart != "undefined"){
		var selStart = tArea.value.substr(0, tArea.selectionStart);
		var selEnd = tArea.value.substr(tArea.selectionEnd, tArea.value.length);
		var curSelection = tArea.value.replace(selStart, '').replace(selEnd, '');
		if(arguments[2]){
			tArea.value = selStart + open + arguments[2] + "]" + curSelection + end + selEnd;
		} else {
			tArea.value = selStart + open + curSelection + end + selEnd;
		}
	} else {
		tArea.value += (arguments[2])? open + arguments[2] + "]" + end : open + end;
	}
}


function loadPostContent(postId, target){
	var target = document.getElementById("updateContent"+postId);
	if (postId) {
		if (obj) {
			target.value = 'Trwa ładownie treści...';
			obj.open("GET", "/actions/loadPostContent.php?postId=" + postId);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.value = obj.responseText;
				}
			}
			obj.send(null);
		}
	}
}


function insertTextInto(target, text) {

	var target = document.getElementById(target);
	target.value = target.value + text;

}

function searchProline(){
	obj.abort();
	var query = document.getElementById('prolineQuery').value;
	var target = document.getElementById('prolineResults');
	if (query) {
		if (obj) {
			target.innerHTML = 'Trwa przeszukiwanie bazy...';
			obj.open("GET", "/actions/searchProline.php?query=" + query);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.innerHTML = obj.responseText;
				}
			}
			obj.send(null);
		}
	}
}

function searchEsc(){
	obj.abort();
	var query = document.getElementById('escQuery').value;
	var target = document.getElementById('escResults');
	if (query) {
		if (obj) {
			target.innerHTML = 'Trwa przeszukiwanie bazy...';
			obj.open("GET", "/actions/searchEsc.php?query=" + query);
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.innerHTML = obj.responseText;
				}
			}
			obj.send(null);
		}
	}
}

function showProlineImg(url){
	Show('prolineImg');
	document.getElementById('prolineImg').src = url;
}


function loadWidget(name){
	obj.abort();
	var target = document.getElementById('widget');
	if (name) {
		if (obj) {
			target.innerHTML = 'Trwa ładowanie widgetu...';
			if (name.match('php')) {
				obj.open("GET", "/widgets/"+name);
			} else {
				obj.open("GET", "/widgets/"+name+".html");
			}
			obj.onreadystatechange = function() {
				if (obj.readyState == 4 && obj.status == 200) {
					target.innerHTML = obj.responseText;
				}
			}
			obj.send(null);
		}
	}
}