
var colibreCurrentThread = 0;
var colibreCommunicatorRefresh = true;

$(document).ready(
	function() {

		$("#jQBarControlLinkOpen").click(
		function() {
			refreshDisabled = false;
			$("#jQBar").slideDown(500, colibreRefresh());
		});

		$("#jQBarControlLinkClose").click(
		function() {
			$("#jQBar").slideUp(500);
			refreshDisabled = true;
		});

		$("#colibreForumCommunicator").mouseover(
		function() {
			colibreCommunicatorRefresh = false;
		});

		$("#colibreForumCommunicator").mouseout(
		function() {
			colibreCommunicatorRefresh = true;
		});

		$("#colibrePostArea").keydown(
		function(evt) {
			if (!evt)
				evt = event;
			if (evt.shiftKey && evt.keyCode == 13)
			{
				colibrePostAnswer();
			}
		});

	}
);

var logostatus = 0;
function logoFun(){
	if (logostatus) {
		$('#benchitLogo').fadeOut(500);
		logostatus = 0;
		alert(1);
	} else {
		$('#benchitLogo').fadeIn(500);
		logostatus = 1;
		alert(0);
	}
	setTimeout("logoFun()", 1000);
}

//logoFun();

var startFrom = 1;
var moduleId = 1;
var refreshActive = false;
var refreshDisabled = false;
var refreshTime = 750;
function colibreRefresh(){

	if (refreshDisabled) return 0;

	setTimeout("colibreRefresh()", refreshTime);

	if (!refreshActive) { refreshActive = true; refreshTime = 1500; return 0; }

	colibreSetStatus('Sending data...');

	switch(moduleId){
		case 1:
			$.ajax({
				url: '/actions/colibrePeopleOnline.php',
				success: function(data) {
					$('#colibrePeopleOnline').html(data);
					$('#colibrePeopleOnline').fadeIn(200);
					colibreSetStatus('Users received.');
				}
			});
			moduleId++;
			break;
		case 2:
			$.ajax({
				url: '/actions/colibreActiveThreads.php',
				success: function(data) {
					$('#colibreActiveThreads').html(data);
					$('#colibreActiveThreads').fadeIn(200);
					colibreSetStatus('Threads received.');
				}
			});
			moduleId++;
			break;
		case 3:
			refreshTime = 1500;
			if (colibreCurrentThread && colibreCommunicatorRefresh) {
				$.ajax({
					url: '/actions/colibreLoadThread.php?threadId='+colibreCurrentThread,
					success: function(data) {
						$('#colibreForumCommunicator').html(data);
						$('#colibreForumCommunicator').fadeIn(200);
						colibreSetStatus('Colibre channel updated.');
					}
				});
			}
			moduleId = startFrom;
			break;
	} // switch

}

function colibreSetStatus(status){
	//$('#colibreStatus').fadeOut(100).html(status).fadeIn(100);
	$('#colibreStatus').html(status);
}

function colibreLoadThread(threadId) {
	colibreSetStatus('Requesting channel...');
	$('#colibreForumCommunicator').fadeOut(500);
	$('#colibrePostSendArea').fadeIn(500);
	colibreCurrentThread = threadId;
	moduleId = 3;
}

function colibrePostAnswer(){

	$.ajax({
		type: "POST",
		url: '/actions/postAnswer.php',
		data: "threadId=" + colibreCurrentThread + "&content=" + encodeURIComponent(getValue('colibrePostArea')),
		success: function(data) {
			moduleId = 3;
			$('#colibrePostArea').val('');
		}
	});

}

function getInnerHTML(id) {
	return document.getElementById(id).innerHTML;
}

function getValue(id) {
	return document.getElementById(id).value;
}